import java.util.*;

public class Tablica implements Iterable{
  private Object tab[];
  Tablica(int size){
    tab = new Object[size];
  }
  public Object get(int index){
    if(index >= tab.length || index < 0){
      throw new ArrayIndexOutOfBoundsException("index = " + index);
    }
    else{
      return tab[index];
    }
  }
  public void set(int index, Object value){
    if(index < 0){
      throw new ArrayIndexOutOfBoundsException("index = " + index);
    }
    if(index >= tab.length){
      resize(index + 1);
    }
    tab[index] = value;
  }
  protected void resize(int size){
    Object newTab[] = new Object[size];
    for(int i = 0; i < tab.length; i++){
      newTab[i] = tab[i];
    }
    tab = newTab;
  }
  public int size(){
    return tab.length;
  }
  public Iterator iterator(){
    return new Iterator(){
      int position = 0;
      public boolean hasNext(){
        return position < tab.length;
      }
      public Object next(){
        return tab[position++];
      }
      public void remove(){
        throw new UnsupportedOperationException();
      }
    };
  }
  public static void main(String args[]){
    Tablica tab = new Tablica(2);
    tab.set(0, 1);
    tab.set(1, 2);
    tab.set(2, new Object());
    for(Object o: tab){
      System.out.println(o);
    }
  }
}
